// dllmain.cpp: Definiuje procedury inicjowania biblioteki DLL.
//

#include "stdafx.h"
#include <afxwin.h>
#include <afxdllx.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

static AFX_EXTENSION_MODULE [!output SAFE_PROJECT_IDENTIFIER_NAME]DLL = { NULL, NULL };

extern "C" int APIENTRY
DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved)
{
	// Usu, jeli uywasz lpReserved
	UNREFERENCED_PARAMETER(lpReserved);

	if (dwReason == DLL_PROCESS_ATTACH)
	{
		TRACE0("Inicjowanie biblioteki [!output PROJECT_NAME].DLL!\n");
		
		// Jednorazowe inicjowanie biblioteki DLL rozszerzenia
		if (!AfxInitExtensionModule([!output SAFE_PROJECT_IDENTIFIER_NAME]DLL, hInstance))
			return 0;

		// Wstaw t bibliotek DLL do acucha zasobw
		// Uwaga: Jeli ta biblioteka DLL rozszerzenia jest niejawnie poczona z
		//  regularn bibliotek DLL MFC (tak jak formant ActiveX)
		//  zamiast aplikacj MFC, bdziesz chcia
		//  usu t lini z funkcji DllMain i umie j w oddzielnej
		//  funkcji wyeksportowanej z tej biblioteki DLL rozszerzenia.  Regularna biblioteka DLL
		//  ktre uywa tej biblioteki DLL rozszerzenia, powinno nastpnie jawnie wywoa
		//  funkcji, aby zainicjowa t bibliotek DLL rozszerzenia.  W przeciwnym razie
		//  obiekt CDynLinkLibrary nie zostanie doczony do
		//  acuch zasobw regularnej biblioteki DLL, co prowadzi do powanych problemw
		//  wynik.

		new CDynLinkLibrary([!output SAFE_PROJECT_IDENTIFIER_NAME]DLL);

[!if SOCKETS]
		// Inicjowanie gniazd
		// Uwaga: Jeli ta biblioteka DLL rozszerzenia jest niejawnie poczona z
		//  regularn bibliotek DLL MFC (tak jak formant ActiveX)
		//  zamiast aplikacj MFC, bdziesz chcia
		//  usu nastpujce linie z funkcji DllMain i umie je w oddzielnej
		//  funkcji wyeksportowanej z tej biblioteki DLL rozszerzenia.  Regularna biblioteka DLL
		//  ktre uywa tej biblioteki DLL rozszerzenia, powinno nastpnie jawnie wywoa
		//  funkcji, aby zainicjowa t bibliotek DLL rozszerzenia.
		if (!AfxSocketInit())
		{
			return FALSE;
		}
	
[!endif]
	}
	else if (dwReason == DLL_PROCESS_DETACH)
	{
		TRACE0("Koczenie biblioteki [!output PROJECT_NAME].DLL!\n");

		// Zakocz bibliotek zanim zostan wywoane destruktory
		AfxTermExtensionModule([!output SAFE_PROJECT_IDENTIFIER_NAME]DLL);
	}
	return 1;   // ok
}
